#!/bin/sh

CATALINA_BASE="${CATALINA_BASE:-/home/jasperreports/jasperserver-tomcat}"
HOSTNAME="${1:-${HOSTNAME}}"
CONNECTOR_PORT="${2:-8443}"
SERVICE_PORT="${3:-8080}"
JMXUSER=jmxproxy
JMXPASSWORD=jmxproxy
CERTBOT_HOME="${CERTBOT_HOME:-$(dirname "${0}")}"

LE_BASE="/etc/letsencrypt/live/${HOSTNAME}"
JAVA_HOME="${JAVA_HOME:-/usr/local/java-8}"

"${CERTBOT_HOME}/certbot-auto" renew

if [ "${LE_BASE}/cert.pem" -nt "${CATALINA_BASE}/${HOSTNAME}.jks" ] ; then

  mv --backup=numbered "${CATALINA_BASE}/${HOSTNAME}.jks" "${CATALINA_BASE}/${HOSTNAME}.jks.bak"
  mv --backup=numbered "${CATALINA_BASE}/${HOSTNAME}.p12" "${CATALINA_BASE}/${HOSTNAME}.p12.bak"

  echo "Creating keystore ${CATALINA_BASE}/${HOSTNAME}.jks from files in $LE_BASE"

  openssl pkcs12 -export -in "${LE_BASE}/cert.pem" -inkey "${LE_BASE}/privkey.pem" \
               -certfile "${LE_BASE}/fullchain.pem" \
               -out "${CATALINA_BASE}/${HOSTNAME}.p12" -name tomcat \
               -passout "pass:changeit"

  "${JAVA_HOME}/bin/keytool" -importkeystore \
    -destkeystore "${CATALINA_BASE}/${HOSTNAME}.jks" \
    -deststorepass "changeit" \
    -srckeystore "${CATALINA_BASE}/${HOSTNAME}.p12" -srcstoretype PKCS12 \
    -srcstorepass "changeit" \
    -alias tomcat

  echo "Restarting Tomcat connector on port ${CONNECTOR_PORT}..."
  result=$(curl -Ss "http://$JMXUSER:$JMXPASSWORD@localhost:${SERVICE_PORT}/manager/jmxproxy?invoke=Catalina%3Atype%3DConnector%2Cport%3D${CONNECTOR_PORT}&op=stop")
  if [ $(expr "$result" : '^OK') -gt 0 ] ; then
    result=$(curl -Ss "http://$JMXUSER:$JMXPASSWORD@localhost:${SERVICE_PORT}/manager/jmxproxy?invoke=Catalina%3Atype%3DConnector%2Cport%3D${CONNECTOR_PORT}&op=start")
    if [ $(expr "$result" : '^OK') -gt 0 ] ; then
      echo "Connector has restarted"
    else
      echo "Error: connector did not start properly; response=$result"
    fi
  else
    echo "Error: connector did not stop properly; response=$result"
  fi
fi

